import requests

from create_index import API_KEY, API_SECRET, index_endpoint


def delete_index():
    # Make the API call
    response = requests.delete(index_endpoint, auth=(API_KEY, API_SECRET))

    # Check for errors
    try:
        status = response.json()['status']
        if status['type'] != 'success':
            print('API reported error:', status['text'])
            return False
    except Exception as e:
        print('Exception occured during reading the delete response')
        print(e, response.content, response.status_code)
        return False

    return True


def main():
    is_successful = delete_index()

    if not is_successful:
        print('Deletion not successful')
    else:
        print('Index deleted successfully')


if __name__ == '__main__':
    main()
