
function fetchResource(input, init) {
  return new Promise((resolve, reject) => {
    chrome.runtime.sendMessage({input, init}, messageResponse => {
      const [response, error] = messageResponse;
      if (response === null) {
        reject(error);
      } else {
        // Use undefined on a 204 - No Content
        const body = response.body ? new Blob([response.body]) : undefined;
        resolve(new Response(body, {
          status: response.status,
          statusText: response.statusText,
        }));
      }
    });
  });
}

function imageIsLoaded(imageElement) {
	return imageElement.complete;
}

function imageIsSmall(imageElement) {

	var width = imageElement.clientWidth;
	var height = imageElement.clientHeight;

	//return (width <= 50 || height <= 50);
	return (width <= 150 && height <= 150);
}

function imageIsOfNonProcessableFormat(imageElement) {
	return (imageElement.src.search(".svg")>-1) || (imageElement.src.search(".png")>-1); // temp fix
}

function replaceImageWithProcessingSVG(imageElement) {

	//console.log('here1');

	if (!imageIsLoaded(imageElement)) return;

	if (imageIsSmall(imageElement) || imageIsOfNonProcessableFormat(imageElement))
	{
		if (imageElement.classList.contains("skip_for_aimode")) return;

		var timestamp = new Date().getTime();
    	imageElement.src=imageElement.src+"?i_fix="+timestamp;
    	imageElement.classList.add("skip_for_aimode");
    	//console.log('here2');
    	returnOriginalImage(imageElement);
    	
		return;
	}

	//console.log('here');

	var width = imageElement.clientWidth;
	var height = imageElement.clientHeight;

	//var width = imageElement.width;
	//var height = imageElement.height;

	var halfWidth = width / 2;
	var halfHeight = height / 2;

	var svgImageDataProcessed = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="' + width + '" height="' + height + '" viewBox="0 0 ' + width + ' ' + height + '"><defs><linearGradient id="grad1" x1="0%" y1="0%" x2="100%" y2="0%"><stop offset="0%" style="stop-color:rgb(102,45,145);stop-opacity:1" /><stop offset="100%" style="stop-color:rgb(218,28,92);stop-opacity:1" /></linearGradient><symbol id="icon-technology-cloud" viewBox="0 0 43.254 38.175"><path class="a" d="M34.509,8.51a2.656,2.656,0,0,0-.781.078,6.76,6.76,0,0,0-6.48-4.528,6.6,6.6,0,0,0-3.591,1.015A8.7,8.7,0,0,0,15.771,0,8.564,8.564,0,0,0,7.183,8.588a12.767,12.767,0,0,0,.156,1.718A7.726,7.726,0,0,0,0,18.035a7.627,7.627,0,0,0,7.183,7.651h3.045V24.594H7.417a6.64,6.64,0,0,1,.312-13.273h.312a.675.675,0,0,0,.468-.234.516.516,0,0,0,.078-.468A6.576,6.576,0,0,1,8.276,8.51a7.514,7.514,0,0,1,7.573-7.5,7.67,7.67,0,0,1,7.1,5c.078.156.156.312.39.312a.516.516,0,0,0,.468-.078A5.784,5.784,0,0,1,32.87,9.291a.618.618,0,0,0,.625.39A5.531,5.531,0,0,1,34.587,9.6a7.5,7.5,0,0,1,1.171,14.912v1.093a8.6,8.6,0,0,0,7.5-8.51A8.907,8.907,0,0,0,34.509,8.51Z"/><g transform="translate(9.246 10.701)"><g transform="translate(0 0)"><g transform="translate(0 0)"><path class="a" d="M22.255,8.172,13.8-.232a5.209,5.209,0,0,0-3.771-1.562A5.3,5.3,0,0,0,6.255-.232l-8.35,8.4a5.209,5.209,0,0,0-1.562,3.771,5.3,5.3,0,0,0,1.562,3.771l8.4,8.4a5.209,5.209,0,0,0,3.771,1.562,5.3,5.3,0,0,0,3.771-1.562l8.4-8.4a5.209,5.209,0,0,0,1.562-3.771A5.534,5.534,0,0,0,22.255,8.172Zm-.808,6.734-8.4,8.458A4.114,4.114,0,0,1,10.08,24.6a4.025,4.025,0,0,1-2.963-1.239L.653,16.9H6.2l1.832,3.232h4.04l2.047-3.5-2.047-3.5H8.033L6.2,16.361H.006l-1.347-1.455A4.114,4.114,0,0,1-2.58,11.943,4.025,4.025,0,0,1-1.341,8.98L7.063.522A4.114,4.114,0,0,1,10.026-.717,4.025,4.025,0,0,1,12.989.522l6.68,6.626h-5.71L12.127,3.916H8.087L6.04,7.418l2.047,3.5h4.04l1.832-3.232h6.3L21.5,8.926a4.114,4.114,0,0,1,1.239,2.963A4.423,4.423,0,0,1,21.447,14.906ZM7.279,16.576l1.4-2.424h2.8l1.4,2.424L11.481,19H8.68Zm5.6-9.158-1.4,2.424H8.68l-1.4-2.424,1.4-2.424h2.8Z" transform="translate(3.657 1.794)"/><path class="technology-b" d="M15.45,12.351,14.1,14.667H8.878L7.531,12.351H4.46L2.9,15.045,4.46,17.738H7.531l1.347-2.37H14.1l1.347,2.37h3.125l1.562-2.694-1.562-2.694Z" transform="translate(2.22 -1.307)"/></g></g></g></symbol></defs><rect width="' + width + '" height="' + height + '" style="fill:url(#grad1)" /><g transform="translate(' + halfWidth + ', ' + halfHeight + ')"><use xlink:href="#icon-technology-cloud" x="-25" y="-' + (halfHeight + 25) + '" width="50" style="fill:white"></use><text baseline-shift="-39px" text-anchor="middle" font-family="Lato" font-size="14" font-style="normal" font-weight="400" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-dashoffset: 0; stroke-linejoin: miter; stroke-miterlimit: 4; fill: rgb(255,255,255); fill-rule: nonzero; opacity: 1; white-space: pre;"><tspan>Analyzing Image ...</tspan></text></g></svg>';

	//var svgImageDataProcessed = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="' + width + '" height="' + height + '" viewBox="0 0 ' + width + ' ' + height + '"><defs><linearGradient id="grad1" x1="0%" y1="0%" x2="100%" y2="0%"><stop offset="0%" style="stop-color:rgb(102,45,145);stop-opacity:1" /><stop offset="100%" style="stop-color:rgb(218,28,92);stop-opacity:1" /></linearGradient><linearGradient id="grad-animated" x1="0" y1="0" x2="100%" y2="0" ><stop offset="0" stop-color="rgb(102,45,145)"><animate attributeName="stop-color" values="rgb(218,28,92);rgb(102,45,145);rgb(218,28,92)" dur="2s" repeatCount="indefinite" /></stop><stop offset="1" stop-color="rgb(218,28,92)"><animate attributeName="stop-color" values="rgb(102,45,145);rgb(218,28,92);rgb(102,45,145)" dur="2s" repeatCount="indefinite" /> </stop></linearGradient><style> .logo-cloud { stroke-dasharray: 200; stroke-dashoffset: 0 } .logo-rect { stroke-dasharray: 200; stroke-dashoffset: 0 } </style><symbol id="icon-technology-cloud" viewBox="0 0 43.254 38.175"><path class="logo-cloud" d="M34.509,8.51a2.656,2.656,0,0,0-.781.078,6.76,6.76,0,0,0-6.48-4.528,6.6,6.6,0,0,0-3.591,1.015A8.7,8.7,0,0,0,15.771,0,8.564,8.564,0,0,0,7.183,8.588a12.767,12.767,0,0,0,.156,1.718A7.726,7.726,0,0,0,0,18.035a7.627,7.627,0,0,0,7.183,7.651h3.045V24.594H7.417a6.64,6.64,0,0,1,.312-13.273h.312a.675.675,0,0,0,.468-.234.516.516,0,0,0,.078-.468A6.576,6.576,0,0,1,8.276,8.51a7.514,7.514,0,0,1,7.573-7.5,7.67,7.67,0,0,1,7.1,5c.078.156.156.312.39.312a.516.516,0,0,0,.468-.078A5.784,5.784,0,0,1,32.87,9.291a.618.618,0,0,0,.625.39A5.531,5.531,0,0,1,34.587,9.6a7.5,7.5,0,0,1,1.171,14.912v1.093a8.6,8.6,0,0,0,7.5-8.51A8.907,8.907,0,0,0,34.509,8.51Z" style="stroke:#febc00"><animate id="l1" attributeName="stroke-dashoffset" begin="0.1s" values="400;0;400" dur="3s" calcMode="linear" repeatCount="indefinite"/></path><g transform="translate(9.246 10.701)"><g transform="translate(0 0)"><g transform="translate(0 0)"><path class="logo-rect" d="M22.255,8.172,13.8-.232a5.209,5.209,0,0,0-3.771-1.562A5.3,5.3,0,0,0,6.255-.232l-8.35,8.4a5.209,5.209,0,0,0-1.562,3.771,5.3,5.3,0,0,0,1.562,3.771l8.4,8.4a5.209,5.209,0,0,0,3.771,1.562,5.3,5.3,0,0,0,3.771-1.562l8.4-8.4a5.209,5.209,0,0,0,1.562-3.771A5.534,5.534,0,0,0,22.255,8.172Zm-.808,6.734-8.4,8.458A4.114,4.114,0,0,1,10.08,24.6a4.025,4.025,0,0,1-2.963-1.239L.653,16.9H6.2l1.832,3.232h4.04l2.047-3.5-2.047-3.5H8.033L6.2,16.361H.006l-1.347-1.455A4.114,4.114,0,0,1-2.58,11.943,4.025,4.025,0,0,1-1.341,8.98L7.063.522A4.114,4.114,0,0,1,10.026-.717,4.025,4.025,0,0,1,12.989.522l6.68,6.626h-5.71L12.127,3.916H8.087L6.04,7.418l2.047,3.5h4.04l1.832-3.232h6.3L21.5,8.926a4.114,4.114,0,0,1,1.239,2.963A4.423,4.423,0,0,1,21.447,14.906ZM7.279,16.576l1.4-2.424h2.8l1.4,2.424L11.481,19H8.68Zm5.6-9.158-1.4,2.424H8.68l-1.4-2.424,1.4-2.424h2.8Z" transform="translate(3.657 1.794)" style="stroke:#262262"><animate id="l2" attributeName="stroke-dashoffset" begin="0.1s" values="200;0;200" dur="3s" calcMode="linear" repeatCount="indefinite"/></path><path class="technology-b" d="M15.45,12.351,14.1,14.667H8.878L7.531,12.351H4.46L2.9,15.045,4.46,17.738H7.531l1.347-2.37H14.1l1.347,2.37h3.125l1.562-2.694-1.562-2.694Z" transform="translate(2.22 -1.307)"></path></g></g></g></symbol></defs><rect width="' + width + '" height="' + height + '" style="fill:url(#grad-animated)" /><g transform="translate(' + halfWidth + ', ' + halfHeight + ')"><use xlink:href="#icon-technology-cloud" x="-25" y="-' + (halfHeight + 25) + '" width="50" style="fill:white"></use><text baseline-shift="-39px" text-anchor="middle" font-family="Lato" font-size="14" font-style="normal" font-weight="400" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-dashoffset: 0; stroke-linejoin: miter; stroke-miterlimit: 4; fill: rgb(255,255,255); fill-rule: nonzero; opacity: 1; white-space: pre;"><tspan>Analyzing Image ...</tspan></text></g></svg>';

	var encoded = window.btoa(svgImageDataProcessed);
	imageElement.style.backgroundImage = "url(data:image/svg+xml;base64,"+encoded+")";
	imageElement.style.backgroundRepeat = "no-repeat";
	imageElement.style.backgroundPosition = "center center";
	//imageElement.style.opacity = "1";

	imageElement.classList.add("needsanalyzing_aimode");
}

function replaceImageWithBlockedSVG(imageElement, blockReason) {

	var width = imageElement.clientWidth;
	var height = imageElement.clientHeight;

	//var width = imageElement.width;
	//var height = imageElement.height;

	var halfWidth = width / 2;
	var halfHeight = height / 2;

	var svgImageDataProcessed = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="' + width + '" height="' + height + '" viewBox="0 0 ' + width + ' ' + height + '"><defs><symbol id="icon-technology-cloud" viewBox="0 0 43.254 38.175"><path class="a" d="M34.509,8.51a2.656,2.656,0,0,0-.781.078,6.76,6.76,0,0,0-6.48-4.528,6.6,6.6,0,0,0-3.591,1.015A8.7,8.7,0,0,0,15.771,0,8.564,8.564,0,0,0,7.183,8.588a12.767,12.767,0,0,0,.156,1.718A7.726,7.726,0,0,0,0,18.035a7.627,7.627,0,0,0,7.183,7.651h3.045V24.594H7.417a6.64,6.64,0,0,1,.312-13.273h.312a.675.675,0,0,0,.468-.234.516.516,0,0,0,.078-.468A6.576,6.576,0,0,1,8.276,8.51a7.514,7.514,0,0,1,7.573-7.5,7.67,7.67,0,0,1,7.1,5c.078.156.156.312.39.312a.516.516,0,0,0,.468-.078A5.784,5.784,0,0,1,32.87,9.291a.618.618,0,0,0,.625.39A5.531,5.531,0,0,1,34.587,9.6a7.5,7.5,0,0,1,1.171,14.912v1.093a8.6,8.6,0,0,0,7.5-8.51A8.907,8.907,0,0,0,34.509,8.51Z"/><g transform="translate(9.246 10.701)"><g transform="translate(0 0)"><g transform="translate(0 0)"><path class="a" d="M22.255,8.172,13.8-.232a5.209,5.209,0,0,0-3.771-1.562A5.3,5.3,0,0,0,6.255-.232l-8.35,8.4a5.209,5.209,0,0,0-1.562,3.771,5.3,5.3,0,0,0,1.562,3.771l8.4,8.4a5.209,5.209,0,0,0,3.771,1.562,5.3,5.3,0,0,0,3.771-1.562l8.4-8.4a5.209,5.209,0,0,0,1.562-3.771A5.534,5.534,0,0,0,22.255,8.172Zm-.808,6.734-8.4,8.458A4.114,4.114,0,0,1,10.08,24.6a4.025,4.025,0,0,1-2.963-1.239L.653,16.9H6.2l1.832,3.232h4.04l2.047-3.5-2.047-3.5H8.033L6.2,16.361H.006l-1.347-1.455A4.114,4.114,0,0,1-2.58,11.943,4.025,4.025,0,0,1-1.341,8.98L7.063.522A4.114,4.114,0,0,1,10.026-.717,4.025,4.025,0,0,1,12.989.522l6.68,6.626h-5.71L12.127,3.916H8.087L6.04,7.418l2.047,3.5h4.04l1.832-3.232h6.3L21.5,8.926a4.114,4.114,0,0,1,1.239,2.963A4.423,4.423,0,0,1,21.447,14.906ZM7.279,16.576l1.4-2.424h2.8l1.4,2.424L11.481,19H8.68Zm5.6-9.158-1.4,2.424H8.68l-1.4-2.424,1.4-2.424h2.8Z" transform="translate(3.657 1.794)"/><path class="technology-b" d="M15.45,12.351,14.1,14.667H8.878L7.531,12.351H4.46L2.9,15.045,4.46,17.738H7.531l1.347-2.37H14.1l1.347,2.37h3.125l1.562-2.694-1.562-2.694Z" transform="translate(2.22 -1.307)"/></g></g></g></symbol></defs><rect width="' + width + '" height="' + height + '" style="fill:#262262" /><g transform="translate(' + halfWidth + ', ' + halfHeight + ')"><use xlink:href="#icon-technology-cloud" x="-25" y="-' + (halfHeight + 25) + '" width="50" style="fill:white"></use><text baseline-shift="-39px" text-anchor="middle" font-family="Lato" font-size="14" font-style="normal" font-weight="400" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-dashoffset: 0; stroke-linejoin: miter; stroke-miterlimit: 4; fill: rgb(255,255,255); fill-rule: nonzero; opacity: 1; white-space: pre;"><tspan x="0" dy=".6em">Image is blocked</tspan><tspan x="0" dy="1.2em">' + blockReason + '</tspan></text></g></svg>';

	var encoded = window.btoa(svgImageDataProcessed);
	imageElement.style.backgroundImage = "url(data:image/svg+xml;base64,"+encoded+")";
	imageElement.style.backgroundRepeat = "no-repeat";
	imageElement.style.backgroundPosition = "center center";
	//imageElement.style.opacity = "1";
}

function returnOriginalImage(imageElement) {
	imageElement.style.backgroundImage = "";
	imageElement.style.backgroundRepeat = "";
	imageElement.style.backgroundPosition = "";
}

async function processImageForSafety(imageElement) {

	//return;

	/*if (!imageIsLoaded(imageElement)) return;

	if (imageIsSmall(imageElement))
	{
		//var timestamp = new Date().getTime();
    	//imageElement.src=imageElement.src+"?i_fix="+timestamp;
    	//returnOriginalImage(imageElement);

		return;
	}*/

	if (!(imageElement.classList.contains("needsanalyzing_aimode"))) return;

	imageElement.classList.remove("needsanalyzing_aimode");


	var newAlgorithm = true;
	
	var address = imageElement.src;

	const response = await fetch('https://testing-api-titan3.on-premise.imagga.com/v2/categories/nsfw_beta_2?image_url=' + address);

	if (response.status !== 200)
	{
        console.log('Looks like there was a problem. Status Code: ' + response.status);
        // TODO moje i tuk za error response da se dobavi ne6to

        // temp fix - unblock non-processable images
        if (newAlgorithm)
	    {
	    	//replaceImageWithBlockedSVG(imageElement, "Error processing");

		    {
		    	var timestamp = new Date().getTime();
		    	imageElement.src=imageElement.src+"?i_fix="+timestamp;
		    	returnOriginalImage(imageElement);
		    }
	    }

    }
      else
      {

    const json = await response.json();
    //console.log(json);

		try {
				var imageIsSafe = 1;
				var blockReason = "Contains ";
				// TODO better handling for max confidence, maybe a whole endpoint on the CM platform with multiple models combined?
				for(var c = 0; c < json.result.categories.length; c++)
				{
			        if (json.result.categories[c].name.en != "safe" && json.result.categories[c].confidence > 20)
			        {
			        	imageIsSafe = 0;
			        	if (json.result.categories[c].name.en == "nsfw")
			        	{
			        		blockReason += "NSFW Content";
			        	}
			        	else if (json.result.categories[c].name.en == "underwear")
			        	{
			        		blockReason += "Underwear";
			        	}
			        	break;
			        }
			    }

			    if (newAlgorithm)
			    {
			    	if (imageIsSafe == 1)
				    {
				    	var timestamp = new Date().getTime();
				    	imageElement.src=imageElement.src+"?i_fix="+timestamp;
				    	returnOriginalImage(imageElement);
				    }
				    else
				    {
				    	replaceImageWithBlockedSVG(imageElement, blockReason);
				    }
			    }
			    else
			    {
				    if (imageIsSafe == 1)
				    {
				    	var timestamp = new Date().getTime();
						//img.setAttribute('src', address+"?i_fix="+timestamp);
						//e.target.appendChild(img);
						imageElement.src=imageElement.src+"?i_fix="+timestamp;
				    }
				    else
				    {
				    	imageElement.classList.add("needtoblockimagestyle");
				    }

				    imageElement.classList.remove("needtoanalyzeimagestyle");
				}
			    
		    }
		    finally {
		    }
	}
}

async function handleIMGS(textNode) {

	var newAlgorithm = true;
	//var newAlgorithm = false;

	try {

		//console.log('handleIMGS');

		var _allImagesList_ = textNode.getElementsByTagName('img');

		for(var i = 0; i < _allImagesList_.length; i++)
		{
			if (newAlgorithm)
			{
				replaceImageWithProcessingSVG(_allImagesList_[i]);

				_allImagesList_[i].onload = function() {
					replaceImageWithProcessingSVG(this);
					processImageForSafety(this);
				};
			}
			else
			{
				_allImagesList_[i].classList.add("needtoanalyzeimagestyle");
			}

			/*var address = _allImagesList_[i].src;


			/*_allImagesList_[i].addEventListener('click', function (e) {
				var img = document.createElement('img');
				var timestamp = new Date().getTime();
				//img.setAttribute('src', address+"?i_fix="+timestamp);
				//e.target.appendChild(img);
				this.src=this.src+"?i_fix="+timestamp;
				this.classList.remove("needtoanalyzeimagestyle");
			});*/
		}

		// for(var i = 0; i < _allImagesList_.length; i++)
		// {
		// 	var address = _allImagesList_[i].src;

		// 	/*fetch('https://testing-api-titan3.on-premise.imagga.com/v2/categories/nsfw_beta_2?image_url=' + address)
		// 	  .then(
		// 	    function(response) {
		// 	      if (response.status !== 200) {
		// 	        console.log('Looks like there was a problem. Status Code: ' +
		// 	          response.status);
		// 	        return;
		// 	      }

		// 	      // Examine the text in the response
		// 	      response.json().then(function(data) {
		// 	        console.log(data);
		// 	      });
		// 	    }
		// 	  )
		// 	  .catch(function(err) {
		// 	    console.log('Fetch Error :-S', err);
		// 	  });*/

		// 	const response = await fetch('https://testing-api-titan3.on-premise.imagga.com/v2/categories/nsfw_beta_2?image_url=' + address);

		// 	if (response.status !== 200)
		// 	{
		//         console.log('Looks like there was a problem. Status Code: ' + response.status);
		//         // TODO moje i tuk za error response da se dobavi ne6to
		//     }
		//       else
		//       {

		//     const json = await response.json();
		//     console.log(json);

		// 		try {
		// 				var imageIsSafe = 1;
		// 				var blockReason = "Contains ";
		// 				// TODO better handling for max confidence, maybe a whole endpoint on the CM platform with multiple models combined?
		// 				for(var c = 0; c < json.result.categories.length; c++)
		// 				{
		// 			        if (json.result.categories[c].name.en != "safe" && json.result.categories[c].confidence > 20)
		// 			        {
		// 			        	imageIsSafe = 0;
		// 			        	if (json.result.categories[c].name.en == "nsfw")
		// 			        	{
		// 			        		blockReason += "NSFW Content";
		// 			        	}
		// 			        	else if (json.result.categories[c].name.en == "underwear")
		// 			        	{
		// 			        		blockReason += "Underwear";
		// 			        	}
		// 			        	break;
		// 			        }
		// 			    }

		// 			    if (newAlgorithm)
		// 			    {
		// 			    	if (imageIsSafe == 1)
		// 				    {
		// 				    	_allImagesList_[i].src=_allImagesList_[i].src+"?i_fix="+timestamp;
		// 				    	returnOriginalImage(_allImagesList_[i]);
		// 				    }
		// 				    else
		// 				    {
		// 				    	replaceImageWithBlockedSVG(_allImagesList_[i], blockReason);
		// 				    }
		// 			    }
		// 			    else
		// 			    {
		// 				    if (imageIsSafe == 1)
		// 				    {
		// 				    	var timestamp = new Date().getTime();
		// 						//img.setAttribute('src', address+"?i_fix="+timestamp);
		// 						//e.target.appendChild(img);
		// 						_allImagesList_[i].src=_allImagesList_[i].src+"?i_fix="+timestamp;
		// 				    }
		// 				    else
		// 				    {
		// 				    	_allImagesList_[i].classList.add("needtoblockimagestyle");
		// 				    }

		// 				    _allImagesList_[i].classList.remove("needtoanalyzeimagestyle");
		// 				}
					    
		// 		    }
		// 		    finally {
		// 		    }
		// 	}

		// 	//if (i >= 10) break;
		// }

		for(var i = 0; i < _allImagesList_.length; i++)
		{
			processImageForSafety(_allImagesList_[i]);

			//if (i >= 10) break;
		}

	} catch (error){
		console.log("e ai mode: "+error);
	}
}
var localStorageIsOn="0";
chrome.storage.sync.get('localStorageIsOn', function(items){
    localStorageIsOn = items['localStorageIsOn'];
	//if (localStorageIsOn=="1") {
    	//console.log('asdasddasasd');
		handleIMGS(document);
	//}
	chrome.storage.local.clear(function() {});
});
